program p_5_3;

{// D O L O N C Z O N E   M O D U L Y
{///////////////////////////////////////}
uses crt,graf_fx;

{// M O J E   T Y P Y   D A N Y C H
{///////////////////////////////////////}

type wielka_tablica = array[0..63999] of byte;

type obraz = record
              szerokosc : word;
              wysokosc : word;
              wsk_obrazu : ^wielka_tablica;
              rozmiar : word;
             end;

type naglowek_pliku_BMP = record
                           typ_obrazu : array[0..1] of char;
                           rozmiar_pliku : longint;
                           zarezerwowane1 : word;
                           zarezerwowane2 : word;
                           odleglosc_do_obrazu : longint;
                           rozmiar_naglowka_info : longint;
                           szerokosc_obrazu : longint;
                           wysokosc_obrazu : longint;
                           liczba_planow_obrazu : word;
                           liczba_bitow_na_piksel : word;
                           typ_kompresji : longint;
                           rozmiar_obrazu : longint;
                           pozioma_rozdziel_DPI : longint;
                           pionowa_rozdziel_DPI : longint;
                           liczba_uzywanych_kolorow : longint;
                           liczba_znaczacych_kolorow : longint;
                          end;

type wzorzec_koloru_BMP = record
                           niebieski : byte;
                           zielony : byte;
                           czerwony : byte;
                           zarezerwowany : byte;
                          end;


{// Z M I E N N E   G L O B A L N E
{///////////////////////////////////////}
var
tab_kolorow : array[0..255] of wzorzec_koloru_BMP;
rysunek : obraz;
plik : file;
licznik, wynik : word;

{// P R O C E D U R Y
{///////////////////////////////////////}

procedure g_laduj_BMP_13h( var z_obraz : obraz; szciezka : string);
var
plik : file;
naglowek : naglowek_pliku_BMP;
licznik, wynik : word;
licznik_odczytu : word;
begin

{Skojarzenie zbiory ze zmienna plikowa i otworzenie go}
assign(plik, szciezka);
reset(plik, 1);

{odczyt naglowka bitmapy}
licznik := sizeof(naglowek_pliku_BMP);
blockread(plik, naglowek, licznik, wynik);

{Sprawdzenie czy rozmiary obrazu sa zgodne z rozdzielczoscia ekranu }
if((naglowek.szerokosc_obrazu > 320) or
   (naglowek.wysokosc_obrazu > 200)) then
   begin
   close(plik);   {zamkniecie pliku}
   exit;          {opuszczenie procedury}
   end;  {koniec if then}

{przeskakujemy palete kolorow}
seek(plik,1078);

{zapisanie rozmiarow obrazu i oblicznie rozmiaru bloku pamieci
 potrzebnego do przechowywania obrazu}
z_obraz.szerokosc := naglowek.szerokosc_obrazu;
z_obraz.wysokosc := naglowek.wysokosc_obrazu;
z_obraz.rozmiar := naglowek.szerokosc_obrazu * naglowek.wysokosc_obrazu;

{Sparwdzamy czy system posiada dosc wolen pamieci do przechowywania
 ladowanego obrazu bitmapy, jezeli jest jej zamalo opuszczamy procedure}
if(maxavail < z_obraz.rozmiar) then
   begin
   close(plik);  {zamkniecie pliku}
   exit;         {opuszczenie procedury}
   end;  {koniec if then}

{przydzielenie pamieci dla obrazu}
getmem(z_obraz.wsk_obrazu, z_obraz.rozmiar);

{zaladowanie obrazu - obraz podczas odczytu zostaje odwrucony w pionie}
licznik := naglowek.szerokosc_obrazu;
for licznik_odczytu := 0 to naglowek.wysokosc_obrazu - 1 do
begin
blockread(plik, z_obraz.wsk_obrazu^[(naglowek.wysokosc_obrazu - 1 - licznik_odczytu) * z_obraz.szerokosc], licznik, wynik);
end; {koniec petli for}

{zamkniecie pliku}
close(plik);

end; {koniec procedury g_laduj_BMP_13h}

{// G L O W N Y   P R O G R A M
{///////////////////////////////////////}

begin

{zaladowanie bitmapy}
g_laduj_BMP_13h(rysunek, 'maska.bmp');

{uruchomienie trybu 320x200x256}
g_ustaw_tryb_vga($13);

{odczytanie palety kolorow}
assign(plik, 'maska.bmp');
reset(plik, 1);
seek(plik, 54); {<- przeskakujemy naglowki bitmapy}
licznik := sizeof(tab_kolorow);
blockread(plik,tab_kolorow, licznik, wynik);
close(plik);

{zaladowanie odczytanej palety kolorow do palety karty graficznej}
port[$3c8] := 0; {zaczynamy zapis palety kolorow od pierwszego jej wzorca}

for licznik := 0 to 255 do {zapis w petli wszytkich 255 wzorcow}
begin
port[$3c9] := tab_kolorow[licznik].czerwony shr 2;
port[$3c9] := tab_kolorow[licznik].zielony shr 2;
port[$3c9] := tab_kolorow[licznik].niebieski shr 2;
end; {koniec petli for}

{wyswietlenie obrazu - przeslanie danych z bufora obrazu do bufora wideo}
for licznik := 0 to rysunek.rozmiar do
    mem[$A000:licznik] := rysunek.wsk_obrazu^[licznik];

{zwolnienie pamieci przydzielonej pod obraz}
freemem(rysunek.wsk_obrazu, rysunek.rozmiar);

{czekanie na dowolny klawisz}
readkey;

end. {koniec programu}